/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package viergewinnt;

import java.awt.Color;
import java.awt.Graphics;

/**
 *
 * @author ivo
 */
public class Gui extends javax.swing.JFrame {
    
    public static final int width = 7;
    public static final int height = 6;
    public static final int thinkingTime = 100;
    

    public AbstractField field;
    public Strategy strategy;
    
    private boolean computerThinking = false;
    private boolean gameOver = false;
    private boolean computerPlaysBoth = false;
    
    /**
     * Creates new form Gui
     */
    public Gui() {
        newField();
        initComponents();
    }
    
    private void newField() {
         field = new BitField(width,height);
         strategy = new Strategy(field);
    }
    
    public void paintField(Graphics g) {
        int w = jPanel1.getWidth();
        int h = jPanel1.getHeight();
        g.clearRect(0,0,w,h);
        int r = (w-1)/width;
        if ((h-1)/height < r) {
            r = (h-1)/height;
        }
        for (int x=0; x<=width; x++) {
            g.drawLine(x*r, 0, x*r, height*r);
        }
        for (int y=0; y<=height; y++) {
            g.drawLine(0,y*r, width*r, y*r);
        }
        for (int x=0; x<width; x++) {
            for (int y=0; y<height; y++) {
                int p = field.getField(x, height-y-1);
                if (p>=0) {
                    if (p==0) {
                        g.setColor(Color.BLUE);
                    } else {
                        g.setColor(Color.PINK);
                    }
                    g.fillOval(x*r+2, y*r+2, r-4, r-4);                    
                }
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        titleLabel = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel() {
            public void paint(Graphics g) {
                super.paint(g);
                paintField(g);
            }
        };
        ;
        startMeButton = new javax.swing.JButton();
        startComputerButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18)); // NOI18N
        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleLabel.setText("Vier gewinnt");
        titleLabel.setToolTipText("");

        jPanel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jPanel1MouseClicked(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 440, Short.MAX_VALUE)
        );

        startMeButton.setText("Start Game, me first");
        startMeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startMeButtonActionPerformed(evt);
            }
        });

        startComputerButton.setText("Start Game, computer first");
        startComputerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startComputerButtonActionPerformed(evt);
            }
        });

        jButton1.setText("Computer against itself");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(titleLabel)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(startMeButton)
                        .addGap(18, 18, 18)
                        .addComponent(startComputerButton)
                        .addGap(18, 18, 18)
                        .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(titleLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(startMeButton)
                    .addComponent(startComputerButton)
                    .addComponent(jButton1))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jPanel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jPanel1MouseClicked
        int w = jPanel1.getWidth();
        int h = jPanel1.getHeight();
        int r = (w-1)/width;
        if ((h-1)/height < r) {
            r = (h-1)/height;
        }
        int x = evt.getX()/r;
        boolean startComputer = false;
        synchronized(this) {
            if (gameOver) {
                return;
            }
            if (!computerThinking) {
                if (field.isOpen(x)) {
                    field.makeMove(x);
                    jPanel1.repaint();                    
                    if (field.checkWin(1-field.getPlayer())) {
                        titleLabel.setText("Congratulations! You won!");
                        gameOver = true;
                    } else if (field.checkDraw()) {
                        titleLabel.setText("This game is a draw.");
                        gameOver = true;                        
                    } else {
                        computerThinking = true;
                        startComputer = true;
                    }
                } else {
                    titleLabel.setText("Sorry, column is full");
                }
            } else {
                titleLabel.setText("Please be patient...");
            }
        }
        if (startComputer) {
            startThinking();
        }
    }//GEN-LAST:event_jPanel1MouseClicked

    private void startMeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startMeButtonActionPerformed
        synchronized(this) {
            if (!computerThinking) {
                computerPlaysBoth = false;
                newField();
                jPanel1.repaint();
                titleLabel.setText("Make your move.");
                gameOver = false;
            }
        }
    }//GEN-LAST:event_startMeButtonActionPerformed

    private void startComputerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startComputerButtonActionPerformed
        synchronized(this) {
            if (!computerThinking) {
                computerThinking=true;
                computerPlaysBoth = false;
                newField();
                gameOver = false;
                jPanel1.repaint();
            }
        }
        startThinking();
    }//GEN-LAST:event_startComputerButtonActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        synchronized(this) {
            if (!computerThinking) {
                computerThinking=true;
                computerPlaysBoth = true;
                newField();
                gameOver = false;
                jPanel1.repaint();
            }
        }
        startThinking();
    }//GEN-LAST:event_jButton1ActionPerformed

    
    private void startThinking() {
        titleLabel.setText("Computing next move...");
        startMeButton.setEnabled(false);
        startComputerButton.setEnabled(false);
        jButton1.setEnabled(false);
        final Gui sync = this;
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                strategy.makeMove(thinkingTime);
                jPanel1.repaint();
                synchronized(sync) {
                    if (field.checkWin(1-field.getPlayer())) {
                        titleLabel.setText("The computer won!");
                        gameOver = true;
                    } else if (field.checkDraw()) {
                        titleLabel.setText("This game is a draw.");
                        gameOver = true;                        
                    } else {
                        titleLabel.setText("Your turn.");
                    }
                }
                if (computerPlaysBoth && !gameOver) {
                    startThinking();
                } else {
                    startComputerButton.setEnabled(true);
                    startMeButton.setEnabled(true);
                    jButton1.setEnabled(true);
                    computerThinking=false;
                }
            }
        });
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Gui.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Gui.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Gui.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Gui.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        
        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new Gui().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton startComputerButton;
    private javax.swing.JButton startMeButton;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables
}
