/*
 * This class is not used anymore, but left here as a (bad) example ;-)
 */
package viergewinnt;

/**
 *
 * @author ivo
 */
public class BitFieldClumsy extends AbstractField {
    

    // BitFieldClumsy for both players 
    private int[][] players;
    
    // number of pieces per column
    private int[] nums;
    
    // history of moves (for undo)
    private int[] history;
    
    
    
    public BitFieldClumsy(int w, int h) {
        super(w,h);
        
        players = new int[2][h];       
        nums = new int[w];        
        history = new int[width*height];
    }

    
    @Override
    public void makeMove(int column) {
        // Check move
//        if (column<0 || column>=width) {
//            throw new RuntimeException(String.format("Column %d out of range [0,%d]",column, width-1));    
//        }
        int h = nums[column];
//        if (nums[column]>=height) {
//            throw new RuntimeException(String.format("Column %d is already full",column));
//        }
        // Execute move
        int player = turnCounter % 2;
        players[player][h] |= 1 << column;
        nums[column]++;
        // Store history
        history[turnCounter++]=column;
        
    }
    
    @Override
    public void undoMove() {
//        if (turnCounter<1) {
//            throw new RuntimeException("No undo possible");
//        }
        turnCounter--;
        int player = turnCounter % 2;
        int h = --nums[history[turnCounter]];
        players[player][h] ^= 1 << history[turnCounter];
    }
    
    // Check if the given player (0 or 1) has won
    @Override
    public boolean checkWin(int player) {
        // horizontal
        for (int h=0; h<height; h++) {
            if ((players[player][h] & (players[player][h] << 1) & (players[player][h] << 2) & (players[player][h] << 3)) != 0) {
                return true;
            }
        }
        // vertical
        for (int h=0; h<height-3; h++) {
            if ((players[player][h] & players[player][h+1] & players[player][h+2] & players[player][h+3])!=0) {
                return true;
            }
        }
        // diagonal (bottom left to top right)
        for (int h=0; h<height-3; h++) {
            if ((players[player][h] & (players[player][h+1] << 1) & (players[player][h+2] << 2) & (players[player][h+3] << 3))!=0) {
                return true;
            }
        }
        // diagonal (bottom right to top left)
        for (int h=0; h<height-3; h++) {
            if (((players[player][h] << 3) & (players[player][h+1] << 2) & (players[player][h+2] << 1) & players[player][h+3])!=0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double evaluatePlayerZero() {
        if (checkWin(0)) {
            return 1.0;
        }
        if (checkWin(1)) {
            return -1.0;
        }
        double e = evaluate(0)-evaluate(1);
        //System.out.format("score = %f%n", e);
        return e;
    }
    
    public double evaluate(int player) {
        
        // Overestimation of the maximal total score.
        // A piece can be part of four in 4 directions at 4 positions.
        int max = height*width*4*4;
        
        // empty or player
        int[] empty = new int[height];
        
        for (int h=0; h<height; h++) {
            empty[h] = ((1 << width)-1) ^ players[1-player][h];
        }
        int sum = 0;
        
        // horizontal, number of pieces times possibilities in participating in four
        for (int h=0; h<height; h++) {
            sum += Integer.bitCount(players[player][h] & (empty[h] << 1) & (empty[h] << 2) & (empty[h] << 3));
            sum += Integer.bitCount(empty[h] & (players[player][h] << 1) & (empty[h] << 2) & (empty[h] << 3));
            sum += Integer.bitCount(empty[h] & (empty[h] << 1) & (players[player][h] << 2) & (empty[h] << 3));
            sum += Integer.bitCount(empty[h] & (empty[h] << 1) & (empty[h] << 2) & (players[player][h] << 3));
        }
        // vertical
        for (int h=0; h<height-3; h++) {
            sum+=Integer.bitCount(players[player][h] & empty[h+1] & empty[h+2] & empty[h+3]);
            sum+=Integer.bitCount(empty[h] & players[player][h+1] & empty[h+2] & empty[h+3]);
            sum+=Integer.bitCount(empty[h] & empty[h+1] & players[player][h+2] & empty[h+3]);
            sum+=Integer.bitCount(empty[h] & empty[h+1] & empty[h+2] & players[player][h+3]);
        }
        // diagonal (bottom left to top right)
        for (int h=0; h<height-3; h++) {
            sum += Integer.bitCount(players[player][h] & (empty[h+1] << 1) & (empty[h+2] << 2) & (empty[h+3] << 3));
            sum += Integer.bitCount(empty[h] & (players[player][h+1] << 1) & (empty[h+2] << 2) & (empty[h+3] << 3));
            sum += Integer.bitCount(empty[h] & (empty[h+1] << 1) & (players[player][h+2] << 2) & (empty[h+3] << 3));
            sum += Integer.bitCount(empty[h] & (empty[h+1] << 1) & (empty[h+2] << 2) & (players[player][h+3] << 3));
        }
        // diagonal (bottom right to top left)
        for (int h=0; h<height-3; h++) {
            sum += Integer.bitCount((players[player][h] << 3) & (empty[h+1] << 2) & (empty[h+2] << 1) & empty[h+3]);
            sum += Integer.bitCount((empty[h] << 3) & (players[player][h+1] << 2) & (empty[h+2] << 1) & empty[h+3]);
            sum += Integer.bitCount((empty[h] << 3) & (empty[h+1] << 2) & (players[player][h+2] << 1) & empty[h+3]);
            sum += Integer.bitCount((empty[h] << 3) & (empty[h+1] << 2) & (empty[h+2] << 1) & players[player][h+3]);
        }
        
        //System.out.format("evaluate(%d): sum=%d%n",player,sum);
        
        return ((double)sum)/max;
    }

    @Override
    public int getField(int x, int y) {
        if (((players[0][y] >> x) & 1) == 1) {
            return 0;
        }
        if (((players[1][y] >> x) & 1) == 1) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isOpen(int column) {
        return (nums[column]<height);
    }

    @Override
    public int getPlayer() {
        return turnCounter % 2;
    }

    @Override
    public boolean checkDraw() {
        return turnCounter == width*height;
    }
}
