/*
 * Decompiled with CFR 0.152.
 */
package viergewinnt;

import java.util.Scanner;
import viergewinnt.AbstractField;
import viergewinnt.BitField;

public class VierGewinnt {
    static AbstractField field = new BitField(7, 6);
    static int bestPosition;

    public static void main(String[] args) {
        Scanner s = new Scanner(System.in);
        while (!field.checkWin(1 - field.getPlayer())) {
            System.out.format("%s%n", field);
            field.evaluatePlayerZero();
            if (field.getPlayer() == 0) {
                System.out.format("Input row number >", new Object[0]);
                field.makeMove(s.nextInt());
                continue;
            }
            long startTime = System.nanoTime();
            startTime = System.nanoTime();
            double v = VierGewinnt.iterativeDeepening(1000);
            startTime = System.nanoTime() - startTime;
            System.out.format("Alpha-Beta-Pruning : %fms, value %f, decision %d%n", (double)startTime / 1000000.0, v, bestPosition);
            field.makeMove(bestPosition);
        }
        System.out.format("%s%n", field);
    }

    public static double evaluateSituation(int maxDepth, boolean first) {
        double mul = field.getPlayer() == 0 ? 1.0 : -1.0;
        double bestv = -1.0;
        boolean found = false;
        for (int w = 0; w < VierGewinnt.field.width; ++w) {
            if (!field.isOpen(w)) continue;
            if (first && !found) {
                bestPosition = w;
                found = true;
            }
            field.makeMove(w);
            double v = field.checkWin(1 - field.getPlayer()) ? 1.0 : (field.checkDraw() ? 0.0 : (maxDepth == 0 ? mul * field.evaluatePlayerZero() : -VierGewinnt.evaluateSituation(maxDepth - 1, false)));
            field.undoMove();
            if (v == 1.0) {
                if (first) {
                    bestPosition = w;
                }
                return 1.0;
            }
            if (!(v > bestv)) continue;
            if (first) {
                bestPosition = w;
            }
            bestv = v;
        }
        return bestv;
    }

    public static double alphaBetaPruning(int maxDepth, boolean first, double alpha, double beta) {
        boolean found = false;
        double mul = field.getPlayer() == 0 ? 1.0 : -1.0;
        for (int w = 0; w < VierGewinnt.field.width; ++w) {
            if (!field.isOpen(w)) continue;
            if (first && !found) {
                bestPosition = w;
                found = true;
            }
            field.makeMove(w);
            double v = field.checkWin(1 - field.getPlayer()) ? 1.0 : (field.checkDraw() ? 0.0 : (maxDepth == 0 ? mul * field.evaluatePlayerZero() : -VierGewinnt.alphaBetaPruning(maxDepth - 1, false, -beta, -alpha)));
            field.undoMove();
            if (v > alpha) {
                if (first) {
                    bestPosition = w;
                }
                alpha = v;
            }
            if (beta <= alpha) {
                return alpha;
            }
            if (!first) continue;
        }
        return alpha;
    }

    public static double iterativeDeepening(int maxMilis) {
        double v = 0.0;
        for (int d = 6; d < VierGewinnt.field.width * VierGewinnt.field.height; d += 2) {
            long startTime = System.nanoTime();
            v = VierGewinnt.alphaBetaPruning(d, true, -1.0, 1.0);
            startTime = (System.nanoTime() - startTime) / 1000000L;
            System.out.format("Depth %d, value %f, decision %d, %dms%n", d, v, bestPosition, startTime);
            if (startTime <= (long)maxMilis && v != 1.0) continue;
            return v;
        }
        return v;
    }
}

