/*
 * Decompiled with CFR 0.152.
 */
package viergewinnt;

import viergewinnt.AbstractField;

public class BitField
extends AbstractField {
    private int[][] players;
    private int[] nums;
    private int[] history;

    public BitField(int w, int h) {
        super(w, h);
        this.players = new int[2][h];
        this.nums = new int[w];
        this.history = new int[this.width * this.height];
    }

    @Override
    public void makeMove(int column) {
        if (column < 0 || column >= this.width) {
            throw new RuntimeException(String.format("Column %d out of range [0,%d]", column, this.width - 1));
        }
        int h = this.nums[column];
        if (this.nums[column] >= this.height) {
            throw new RuntimeException(String.format("Column %d is already full", column));
        }
        int player = this.turnCounter % 2;
        int[] nArray = this.players[player];
        int n = h;
        nArray[n] = nArray[n] | 1 << column;
        int n2 = column;
        this.nums[n2] = this.nums[n2] + 1;
        this.history[this.turnCounter++] = column;
    }

    @Override
    public void undoMove() {
        if (this.turnCounter < 1) {
            throw new RuntimeException("No undo possible");
        }
        --this.turnCounter;
        int player = this.turnCounter % 2;
        int n = this.history[this.turnCounter];
        int n2 = this.nums[n] - 1;
        this.nums[n] = n2;
        int h = n2;
        int[] nArray = this.players[player];
        int n3 = h;
        nArray[n3] = nArray[n3] ^ 1 << this.history[this.turnCounter];
    }

    @Override
    public boolean checkWin(int player) {
        int h;
        for (h = 0; h < this.height; ++h) {
            if ((this.players[player][h] & this.players[player][h] << 1 & this.players[player][h] << 2 & this.players[player][h] << 3) == 0) continue;
            return true;
        }
        for (h = 0; h < this.height - 3; ++h) {
            if ((this.players[player][h] & this.players[player][h + 1] & this.players[player][h + 2] & this.players[player][h + 3]) == 0) continue;
            return true;
        }
        for (h = 0; h < this.height - 3; ++h) {
            if ((this.players[player][h] & this.players[player][h + 1] << 1 & this.players[player][h + 2] << 2 & this.players[player][h + 3] << 3) == 0) continue;
            return true;
        }
        for (h = 0; h < this.height - 3; ++h) {
            if ((this.players[player][h] << 3 & this.players[player][h + 1] << 2 & this.players[player][h + 2] << 1 & this.players[player][h + 3]) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public double evaluatePlayerZero() {
        if (this.checkWin(0)) {
            return 1.0;
        }
        if (this.checkWin(1)) {
            return -1.0;
        }
        double e = this.evaluate(0) - this.evaluate(1);
        return e;
    }

    private double evaluate(int player) {
        int h;
        int max = this.height * this.width * 4 * 4;
        int[] empty = new int[this.height];
        for (int h2 = 0; h2 < this.height; ++h2) {
            empty[h2] = (1 << this.width) - 1 ^ this.players[1 - player][h2];
        }
        int sum = 0;
        for (h = 0; h < this.height; ++h) {
            sum += Integer.bitCount(this.players[player][h] & empty[h] << 1 & empty[h] << 2 & empty[h] << 3);
            sum += Integer.bitCount(empty[h] & this.players[player][h] << 1 & empty[h] << 2 & empty[h] << 3);
            sum += Integer.bitCount(empty[h] & empty[h] << 1 & this.players[player][h] << 2 & empty[h] << 3);
            sum += Integer.bitCount(empty[h] & empty[h] << 1 & empty[h] << 2 & this.players[player][h] << 3);
        }
        for (h = 0; h < this.height - 3; ++h) {
            sum += Integer.bitCount(this.players[player][h] & empty[h + 1] & empty[h + 2] & empty[h + 3]);
            sum += Integer.bitCount(empty[h] & this.players[player][h + 1] & empty[h + 2] & empty[h + 3]);
            sum += Integer.bitCount(empty[h] & empty[h + 1] & this.players[player][h + 2] & empty[h + 3]);
            sum += Integer.bitCount(empty[h] & empty[h + 1] & empty[h + 2] & this.players[player][h + 3]);
        }
        for (h = 0; h < this.height - 3; ++h) {
            sum += Integer.bitCount(this.players[player][h] & empty[h + 1] << 1 & empty[h + 2] << 2 & empty[h + 3] << 3);
            sum += Integer.bitCount(empty[h] & this.players[player][h + 1] << 1 & empty[h + 2] << 2 & empty[h + 3] << 3);
            sum += Integer.bitCount(empty[h] & empty[h + 1] << 1 & this.players[player][h + 2] << 2 & empty[h + 3] << 3);
            sum += Integer.bitCount(empty[h] & empty[h + 1] << 1 & empty[h + 2] << 2 & this.players[player][h + 3] << 3);
        }
        for (h = 0; h < this.height - 3; ++h) {
            sum += Integer.bitCount(this.players[player][h] << 3 & empty[h + 1] << 2 & empty[h + 2] << 1 & empty[h + 3]);
            sum += Integer.bitCount(empty[h] << 3 & this.players[player][h + 1] << 2 & empty[h + 2] << 1 & empty[h + 3]);
            sum += Integer.bitCount(empty[h] << 3 & empty[h + 1] << 2 & this.players[player][h + 2] << 1 & empty[h + 3]);
            sum += Integer.bitCount(empty[h] << 3 & empty[h + 1] << 2 & empty[h + 2] << 1 & this.players[player][h + 3]);
        }
        return (double)sum / (double)max;
    }

    @Override
    public int getField(int x, int y) {
        if ((this.players[0][y] >> x & 1) == 1) {
            return 0;
        }
        if ((this.players[1][y] >> x & 1) == 1) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isOpen(int column) {
        return this.nums[column] < this.height - 1;
    }

    @Override
    public int getPlayer() {
        return this.turnCounter % 2;
    }

    @Override
    public boolean checkDraw() {
        return this.turnCounter == this.width * this.height;
    }
}

