/*
 * Decompiled with CFR 0.152.
 */
package hermitboxes;

import hermitboxes.HermitBoxes;

public class Field {
    private HermitBoxes game;
    private long[] fields;
    private long used;
    private int[][] contents;
    private int[][] masks;
    private int[] movePositions;
    private int[] moveDirections;
    private int[] moveColors;
    private long[] moveBackups;
    private int turnCounter = 0;

    public Field(HermitBoxes g) {
        if (g.width * g.height > 64) {
            throw new RuntimeException("Field too big, maximum of 64 positions!");
        }
        this.game = g;
        this.fields = new long[g.colors];
        this.contents = new int[g.width][g.height];
        this.movePositions = new int[g.width * g.height];
        this.moveColors = new int[g.width * g.height];
        this.moveDirections = new int[g.width * g.height];
        this.moveBackups = new long[g.width * g.height];
        this.masks = new int[g.width][g.height];
        this.makeMasks();
    }

    private void makeMasks() {
        for (int x = 0; x < this.game.width; ++x) {
            for (int y = 0; y < this.game.height; ++y) {
                for (int a = x - 1; a <= x + 1; ++a) {
                    if (a < 0 || a >= this.game.width) continue;
                    for (int b = y - 1; b <= y + 1; ++b) {
                        if (b < 0 || b >= this.game.height) continue;
                        int[] nArray = this.masks[x];
                        int n = y;
                        nArray[n] = nArray[n] | 1 << a + b * this.game.width;
                    }
                }
            }
        }
    }

    public boolean makeMove(int x, int y, int c, int d) {
        if (!this.isMoveLegal(x, y, c, d, true)) {
            throw new IllegalArgumentException("see message to stdout");
        }
        int a = x + (d == 1 ? 1 : 0);
        int b = y + (d == 2 ? 1 : 0);
        this.contents[x][y] = c;
        this.used |= (long)(1 << x + y * this.game.width);
        this.moveColors[this.turnCounter] = c;
        this.movePositions[this.turnCounter] = x + y * this.game.width;
        this.moveDirections[this.turnCounter] = d;
        this.moveBackups[this.turnCounter] = this.fields[c];
        int n = c;
        this.fields[n] = this.fields[n] | (long)this.masks[x][y];
        if (d > 0) {
            this.contents[a][b] = c;
            int n2 = c;
            this.fields[n2] = this.fields[n2] | (long)this.masks[a][b];
            this.used |= (long)(1 << a + b * this.game.width);
        }
        ++this.turnCounter;
        return this.isBoardFull();
    }

    public void undoMove() {
        if (this.turnCounter > 0) {
            --this.turnCounter;
            int x = this.movePositions[this.turnCounter] % this.game.width;
            int y = this.movePositions[this.turnCounter] / this.game.width;
            int c = this.moveColors[this.turnCounter];
            int d = this.moveDirections[this.turnCounter];
            int a = x + (d == 1 ? 1 : 0);
            int b = y + (d == 2 ? 1 : 0);
            this.contents[x][y] = 0;
            this.used ^= (long)(1 << x + y * this.game.width);
            this.contents[a][b] = 0;
            this.used ^= (long)(1 << a + b * this.game.width);
        } else {
            throw new RuntimeException("No further undo possible!");
        }
        this.fields[c] = this.moveBackups[this.turnCounter];
    }

    public boolean isMoveLegal(int x, int y, int c, int d, boolean show) {
        if (x < 0 || y < 0 || x >= this.game.width || y >= this.game.height || c < 1 || c > this.game.colors || d < 0 || d > 2) {
            if (show) {
                System.out.format("Parameters out of range: x=%d, y=%d, c=%d, d=%d%n", x, y, c, d);
            }
            return false;
        }
        int a = x + (d == 1 ? 1 : 0);
        int b = y + (d == 2 ? 1 : 0);
        if (a >= this.game.width || b >= this.game.height) {
            if (show) {
                System.out.format("Parameters out of range: x=%d, y=%d, c=%d, d=%d => a=%d, b=%d%n", x, y, c, d, a, b);
            }
            return false;
        }
        if (this.contents[x][y] != 0) {
            if (show) {
                System.out.format("Field x=%d, y=%d not empty (used with color %d)%n", x, y, this.contents[x][y]);
            }
            return false;
        }
        if ((this.fields[c] & (long)(1 << x + y * this.game.width)) > 0L) {
            if (show) {
                System.out.format("Field x=%d, y=%d adjacent to color %d%n", x, y, c);
            }
            return false;
        }
        if (d > 0 && this.contents[a][b] != 0) {
            if (show) {
                System.out.format("Field a=%d, b=%d not empty (used with color %d)%n", a, b, this.contents[a][b]);
            }
            return false;
        }
        if (d > 0 && (this.fields[c] & (long)(1 << x + y * this.game.width)) > 0L) {
            if (show) {
                System.out.format("Field a=%d, b=%d adjacent to color %d%n", a, b, c);
            }
            return false;
        }
        return true;
    }

    public boolean isBoardFull() {
        for (int color = 0; color < this.game.colors; ++color) {
            if (Long.bitCount(this.fields[color]) >= this.game.width * this.game.height) continue;
            return false;
        }
        return true;
    }

    public int getColor(int x, int y) {
        return this.contents[x][y];
    }

    public int getPlayer() {
        return this.turnCounter % 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("   ");
        StringBuilder sep = new StringBuilder("   ");
        for (int x = 0; x < this.game.width; ++x) {
            sep.append("+---");
            sb.append(String.format("  %d ", x));
        }
        sb.append(String.format("%n", new Object[0]));
        sep.append(String.format("+%n", new Object[0]));
        sb.append((CharSequence)sep);
        for (int y = 0; y < this.game.height; ++y) {
            sb.append(String.format(" %d ", y));
            for (int x = 0; x < this.game.width; ++x) {
                if (this.contents[x][y] > 0) {
                    sb.append(String.format("| %d ", this.contents[x][y]));
                    continue;
                }
                sb.append("|   ");
            }
            sb.append(String.format("|%n", new Object[0]));
            sb.append((CharSequence)sep);
        }
        return sb.toString();
    }
}

